%This script takes the lengths of three sides and determines if a triangle can be
%formed with side lengths.  If so, the triangle type (equilateral,
%isosceles, or scalene) and the area is determined.

s1 = input('Enter shortest side of Triangle  ');
s2 = input('Enter next shortest side of triangle  ');
s3 = input('Enter longest side of triangle   ');

if s1 > s2 && s2 > s3     % Check to see if sides were entered in wrong order
    disp('You must enter the sides from shortest to longest!  Try Again!');
    s1 = input('Enter shortest side of Triangle  ');
    s2 = input('Enter next shortest side of triangle  ');
    s3 = input('Enter longest side of triangle   ');
end

if s1 + s2 <= s3    % Not a triangle
    fprintf('These three sides do not form a triangle \n');
    fprintf('The sum of the two shorter sides does not exceed the longest side\n');
else                % Is a triangle, find type and calculate area
    if s1 = s3
        type = 'Equilateral';
    elseif s1 = s2 || s1 = s3
        type = 'Isosceles';
    else
        type = 'Scalene';
    end
    % Calculate Area using Heron's Formula 
    HalfP = (s1+s2+s3)/2;
    Area = sqrt(HalfP*(HalfP-s1)*(HalfP-s2)*(HalfP-s3);
    fprintf('These three sides form a %s Triangle with area = %0.2f \n',type);
end

